from sqlalchemy import Column, Integer, String, DateTime, func, Index
from app.database import Base

class Match(Base):
    __tablename__ = "matches"

    id_jogo = Column(Integer, primary_key=True, index=True)
    time_casa = Column(String(50), index=True)
    time_fora = Column(String(50), index=True)
    placar_casa = Column(Integer)
    placar_fora = Column(Integer)
    data_jogo = Column(DateTime(timezone=True), server_default=func.now(), index=True)

    # Indexes for faster retrieval of team history
    __table_args__ = (
        Index('idx_time_casa_data', 'time_casa', 'data_jogo'),
        Index('idx_time_fora_data', 'time_fora', 'data_jogo'),
    )

class ModelMetrics(Base):
    __tablename__ = "model_metrics"
    
    id = Column(Integer, primary_key=True, index=True)
    timestamp = Column(DateTime(timezone=True), server_default=func.now())
    accuracy_score = Column(Integer) # e.g. 85 for 85%
    total_predictions = Column(Integer)
    model_version = Column(String(50))
