<?php

ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

$tables = [
	'mcKironBrazil',
	'mcKironItaliano',
	'mcKironLatino',
	'mcKironEspanhol',
	'mcKironIngles'
];
$campIds = [
	'1009',
	'1006',
	'1011',
	'1008',
	'1004'
];

function getPartida($book_id, $table){
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, 'https://oaduikfnlwxirpeoqrjc.supabase.co/rest/v1/'.$table.'?book_id=eq.'.$book_id);
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        "apikey: eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJpc3MiOiJzdXBhYmFzZSIsInJlZiI6Im9hZHVpa2ZubHd4aXJwZW9xcmpjIiwicm9sZSI6ImFub24iLCJpYXQiOjE2OTQ0NzIzMjQsImV4cCI6MjAxMDA0ODMyNH0.YJFt69Ld-xZPqWLOuPCJp__hcRRpWL4D3SXclOQUWXU"
    ]);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    $result = curl_exec($ch);
    curl_close($ch);   

    $obj = json_decode($result,true);    

    if(array_key_exists(0,$obj)){
        return TRUE;
    } else {
        return FALSE;
    }
}

function getEventList($campId){
			
    $url = "https://sb2virtuals-altenar2.biahosted.com/api/WidgetVirtuals/GetVirtualEventList?culture=pt-BR&timezoneOffset=180&integration=mcgames2&deviceType=1&numFormat=en-GB&countryCode=BR&champId=$campId&id=35&dbId=12";

	$curl = curl_init($url);
	curl_setopt($curl, CURLOPT_URL, $url);
	curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);

	$headers = array(
	   "accept: */*",
	   "accept-language: pt-BR,pt;q=0.9,en-US;q=0.8,en;q=0.7",
	   "origin: https://mcgames.bet.br",
	   "priority: u=1, i",
	   "referer: https://mcgames.bet.br/",
	   "user-agent: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Safari/537.36"
	);
	curl_setopt($curl, CURLOPT_HTTPHEADER, $headers);
	//for debug only!
	curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, false);
	curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);

	$resp = curl_exec($curl);
	curl_close($curl);

	$obj = json_decode($resp,true);
	
	return $obj['events'];
}

function getEventDetails($book_id){
			
    $url = "https://sb2virtuals-altenar2.biahosted.com/api/WidgetVirtuals/GetVirtualEventDetails?culture=pt-BR&timezoneOffset=180&integration=mcgames2&deviceType=1&numFormat=en-GB&countryCode=BR&eventId=$book_id&id=35&dbId=12";
	$curl = curl_init($url);
	curl_setopt($curl, CURLOPT_URL, $url);
	curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);

	$headers = array(
	   "accept: */*",
	   "accept-language: pt-BR,pt;q=0.9,en-US;q=0.8,en;q=0.7",
	   "origin: https://mcgames.bet.br",
	   "priority: u=1, i",
	   "referer: https://mcgames.bet.br/",
	   "user-agent: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Safari/537.36"
	);
	curl_setopt($curl, CURLOPT_HTTPHEADER, $headers);
	//for debug only!
	curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, false);
	curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);

	$resp = curl_exec($curl);
	curl_close($curl);

	$obj = json_decode($resp,true);
	
	return $obj;
}

function saveData($data, $table){
	$content = json_encode($data);
    $url = 'https://oaduikfnlwxirpeoqrjc.supabase.co/rest/v1/'.$table; 	
	$apiKey = 'eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJpc3MiOiJzdXBhYmFzZSIsInJlZiI6Im9hZHVpa2ZubHd4aXJwZW9xcmpjIiwicm9sZSI6ImFub24iLCJpYXQiOjE2OTQ0NzIzMjQsImV4cCI6MjAxMDA0ODMyNH0.YJFt69Ld-xZPqWLOuPCJp__hcRRpWL4D3SXclOQUWXU';            

	$curl = curl_init($url);
	curl_setopt($curl, CURLOPT_URL, $url);
	curl_setopt($curl, CURLOPT_POST, true);
	curl_setopt($curl, CURLOPT_RETURNTRANSFER, true); 
	$headers = array(
	   "apikey: ".$apiKey,
	   "Authorization: Bearer ".$apiKey,
	   "Content-Type: application/json",
	   "Prefer: return=minimal",
	);
	curl_setopt($curl, CURLOPT_HTTPHEADER, $headers);
	curl_setopt($curl, CURLOPT_POSTFIELDS, $content); 
	$resp = curl_exec($curl);
	curl_close($curl);
}

function saveOdds($details, $date){
	
	$odds = $details['odds'];
	
	$camp = $details['champ']['id'];
	$casa = $details['competitors'][0]['name'];
	$fora = $details['competitors'][1]['name'];
	
	$book_id = $details['id'];
	
	$cmyes = 0;
	$cmno = 0;
	$fmyes = 0;
	$fmno = 0;
	$bttsFTyes = 0;
	$bttsFTno = 0;
	$bttsHTyes = 0;
	$bttsHTno = 0;
	$homeFT = 0;
	$drawFT = 0;
	$awayFT = 0;
	$homeHT = 0;
	$drawHT = 0;
	$awayHT = 0;
	$hd1xFT = 0;
	$hd12FT = 0;
	$hdx2FT = 0;
	$hd1xHT = 0;
	$hd12HT = 0;
	$hdx2HT = 0;
	$pcFT = FALSE;
	$pfFT = FALSE;
	$pcHT = FALSE;
	$pfHT = FALSE;
	
	$pe00FT = 0;
	$pe10FT = 0;
	$pe20FT = 0;
	$pe30FT = 0;
	$pe40FT = 0;
	$pe50FT = 0;
	$pe60FT = 0;
	$pe01FT = 0;
	$pe11FT = 0;
	$pe21FT = 0;
	$pe31FT = 0;
	$pe41FT = 0;
	$pe51FT = 0;
	$pe02FT = 0;
	$pe12FT = 0;
	$pe22FT = 0;
	$pe32FT = 0;
	$pe42FT = 0;
	$pe03FT = 0;
	$pe13FT = 0;
	$pe23FT = 0;
	$pe33FT = 0;
	$pe04FT = 0;
	$pe14FT = 0;
	$pe24FT = 0;
	$pe05FT = 0;
	$pe15FT = 0;
	$pe06FT = 0;
	
	$pe00HT = 0;
	$pe10HT = 0;
	$pe20HT = 0;
	$pe30HT = 0;
	$pe01HT = 0;
	$pe11HT = 0;
	$pe21HT = 0;
	$pe02HT = 0;
	$pe12HT = 0;
	$pe03HT = 0;
	
	foreach($odds AS $k => $odd){
		if($odd['typeId'] == 1){
			if($homeFT == 0){
				$homeFT = $odd['price'];
			} else if($homeHT == 0){
				$homeHT = $odd['price'];
			}
		}
		if($odd['typeId'] == 2){
			if($drawFT == 0){
				$drawFT = $odd['price'];
			} else if($drawHT == 0){
				$drawHT = $odd['price'];
			}
		}
		if($odd['typeId'] == 3){
			if($awayFT == 0){
				$awayFT = $odd['price'];
			} else if($awayHT == 0){
				$awayHT = $odd['price'];
			}
		}
		if($odd['typeId'] == 9){
			if($hd1xFT == 0){
				$hd1xFT = $odd['price'];
			} else if($hd1xHT == 0){
				$hd1xHT = $odd['price'];
			}
		}
		if($odd['typeId'] == 10){
			if($hd12FT == 0){
				$hd12FT = $odd['price'];
			} else if($hd12HT == 0){
				$hd12HT = $odd['price'];
			}
		}
		if($odd['typeId'] == 11){
			if($hdx2FT == 0){
				$hdx2FT = $odd['price'];
			} else if($hdx2HT == 0){
				$hdx2HT = $odd['price'];
			}
		}
		if($odd['typeId'] == 74){
			if($cmyes == 0){
				$cmyes = $odd['price'];
			} else if($fmyes == 0){
				$fmyes = $odd['price'];
			} else if($bttsFTyes == 0){
				$bttsFTyes = $odd['price'];
			} else if($bttsHTyes == 0){
				$bttsHTyes = $odd['price'];
			}
		}
		if($odd['typeId'] == 76){
			if($cmno == 0){
				$cmno = $odd['price'];
			} else if($fmno == 0){
				$fmno = $odd['price'];
			} else if($bttsFTno == 0){
				$bttsFTno = $odd['price'];
			} else if($bttsHTno == 0){
				$bttsHTno = $odd['price'];
			}
		}
		if($odd['typeId'] == 12){
			if($odd['name'] == 'Mais de 1,5'){
				$o15 = $odd['price'];
			}
			if($odd['name'] == 'Mais de 2,5'){
				$o25 = $odd['price'];
			}
			if($odd['name'] == 'Mais de 3,5'){
				$o35 = $odd['price'];
			}
		}
		if($odd['typeId'] == 13){
			if($odd['name'] == 'Menos de 1,5'){
				$u15 = $odd['price'];
			}
			if($odd['name'] == 'Menos de 2,5'){
				$u25 = $odd['price'];
			}
			if($odd['name'] == 'Menos de 3,5'){
				$u35 = $odd['price'];
			}
		}
		if($odd['typeId'] == 54){
			$g0 = $odd['price'];
		}
		if($odd['typeId'] == 56){
			$g1 = $odd['price'];
		}
		if($odd['typeId'] == 58){
			$g2 = $odd['price'];
		}
		if($odd['typeId'] == 734){
			$g3 = $odd['price'];
		}
		if($odd['typeId'] == 712){
			$g4 = $odd['price'];
		}
		if($odd['typeId'] == 714){
			$g5 = $odd['price'];
		}
		if($odd['typeId'] == 716){
			$g6 = $odd['price'];
		}
		if($odd['typeId'] == 70){
			$impar = $odd['price'];
		}
		if($odd['typeId'] == 72){
			$par = $odd['price'];
		}
		if($odd['typeId'] == 418){
			$htft11 = $odd['price'];
		}
		if($odd['typeId'] == 420){
			$htft1x = $odd['price'];
		}
		if($odd['typeId'] == 422){
			$htft12 = $odd['price'];
		}
		if($odd['typeId'] == 424){
			$htftx1 = $odd['price'];
		}
		if($odd['typeId'] == 426){
			$htftxx = $odd['price'];
		}
		if($odd['typeId'] == 428){
			$htftx2 = $odd['price'];
		}
		if($odd['typeId'] == 430){
			$htft21 = $odd['price'];
		}
		if($odd['typeId'] == 432){
			$htft2x = $odd['price'];
		}
		if($odd['typeId'] == 434){
			$htft22 = $odd['price'];
		}
		if($odd['typeId'] == 78){
			$homeBTTSyes = $odd['price'];
		}
		if($odd['typeId'] == 82){
			$drawBTTSyes = $odd['price'];
		}
		if($odd['typeId'] == 86){
			$awayBTTSyes = $odd['price'];
		}
		if($odd['typeId'] == 80){
			$homeBTTSno = $odd['price'];
		}
		if($odd['typeId'] == 84){
			$drawBTTSno = $odd['price'];
		}
		if($odd['typeId'] == 88){
			$awayBTTSno = $odd['price'];
		}
		if($odd['typeId'] == 584){
			$fgt1 = $odd['price'];
		}
		if($odd['typeId'] == 586){
			$fgt2 = $odd['price'];
		}
		if($odd['typeId'] == 588){
			$fgt3 = $odd['price'];
		}
		if($odd['typeId'] == 590){
			$fgt4 = $odd['price'];
		}
		if($odd['typeId'] == 592){
			$fgt5 = $odd['price'];
		}
		if($odd['typeId'] == 594){
			$fgt6 = $odd['price'];
		}
		if($odd['typeId'] == 7){
			$fgt0 = $odd['price'];
		}
		if($odd['typeId'] == 110){
			if($pe00FT == 0){
				$pe00FT = $odd['price'];				
			} else {
				$pe00HT = $odd['price'];				
			}
		}
		if($odd['typeId'] == 114){
			if($pe10FT == 0){
				$pe10FT = $odd['price'];				
			} else {
				$pe10HT = $odd['price'];				
			}
		}
		if($odd['typeId'] == 116){
			if($pe20FT == 0){
				$pe20FT = $odd['price'];				
			} else {
				$pe20HT = $odd['price'];				
			}
		}
		if($odd['typeId'] == 118){
			if($pe30FT == 0){
				$pe30FT = $odd['price'];				
			} else {
				$pe30HT = $odd['price'];				
			}
		}
		if($odd['typeId'] == 120){
			$pe40FT = $odd['price'];
		}
		if($odd['typeId'] == 122){
			$pe50FT = $odd['price'];
		}
		if($odd['typeId'] == 124){
			$pe60FT = $odd['price'];
		}
		if($odd['typeId'] == 126){
			if($pe01FT == 0){
				$pe01FT = $odd['price'];				
			} else {
				$pe01HT = $odd['price'];				
			}
		}
		if($odd['typeId'] == 128){
			if($pe11FT == 0){
				$pe11FT = $odd['price'];				
			} else {
				$pe11HT = $odd['price'];				
			}
		}
		if($odd['typeId'] == 130){
			if($pe21FT == 0){
				$pe21FT = $odd['price'];				
			} else {
				$pe21HT = $odd['price'];				
			}
		}
		if($odd['typeId'] == 132){
			$pe31FT = $odd['price'];
		}
		if($odd['typeId'] == 134){
			$pe41FT = $odd['price'];
		}
		if($odd['typeId'] == 136){
			$pe51FT = $odd['price'];
		}
		if($odd['typeId'] == 138){
			if($pe02FT == 0){
				$pe02FT = $odd['price'];				
			} else {
				$pe02HT = $odd['price'];				
			}
		}
		if($odd['typeId'] == 140){
			if($pe12FT == 0){
				$pe12FT = $odd['price'];				
			} else {
				$pe12HT = $odd['price'];				
			}
		}
		if($odd['typeId'] == 142){
			$pe22FT = $odd['price'];
		}
		if($odd['typeId'] == 144){
			$pe32FT = $odd['price'];
		}
		if($odd['typeId'] == 146){
			$pe42FT = $odd['price'];
		}
		if($odd['typeId'] == 148){
			if($pe03FT == 0){
				$pe03FT = $odd['price'];				
			} else {
				$pe03HT = $odd['price'];				
			}
		}
		if($odd['typeId'] == 150){
			$pe13FT = $odd['price'];
		}
		if($odd['typeId'] == 152){
			$pe23FT = $odd['price'];
		}
		if($odd['typeId'] == 154){
			$pe33FT = $odd['price'];
		}
		if($odd['typeId'] == 156){
			$pe04FT = $odd['price'];
		}
		if($odd['typeId'] == 158){
			$pe14FT = $odd['price'];
		}
		if($odd['typeId'] == 160){
			$pe24FT = $odd['price'];
		}
		if($odd['typeId'] == 162){
			$pe05FT = $odd['price'];
		}
		if($odd['typeId'] == 164){
			$pe15FT = $odd['price'];
		}
		if($odd['typeId'] == 166){
			$pe06FT = $odd['price'];
		}
	}
	
	$data = [
		'homeTeam' => $casa,
		'awayTeam' => $fora,
		'camp' => $camp,
		'date' => $date,
		'homeFT' => $homeFT,
		'homeHT' => $homeHT,
		'drawFT' => $drawFT,
		'drawHT' => $drawHT,
		'awayFT' => $awayFT,
		'awayHT' => $awayHT,
		'hd1xFT' => $hd1xFT,
		'hd1xHT' => $hd1xHT,
		'hdx2FT' => $hdx2FT,
		'hdx2HT' => $hdx2HT,
		'hd12FT' => $hd12FT,
		'hd12HT' => $hd12HT,
		'cmy' => $cmyes,
		'cmn' => $cmno,
		'fmy' => $fmyes,
		'fmn' => $fmno,
		'bttsyFT' => $bttsFTyes,
		'bttsyHT' => $bttsHTyes,
		'bttsnFT' => $bttsFTno,
		'bttsnHT' => $bttsHTno,
		'o15' => $o15,
		'o25' => $o25,
		'o35' => $o35,
		'u15' => $u15,
		'u25' => $u25,
		'u35' => $u35,
		'g0' => $g0,
		'g1' => $g1,
		'g2' => $g2,
		'g3' => $g3,
		'g4' => $g4,
		'g5' => $g5,
		'g6' => $g6,
		'impar' => $impar,
		'par' => $par,
		'htft11' => $htft11,
		'htft1x' => $htft1x,
		'htft12' => $htft12,
		'htftx1' => $htftx1,
		'htftxx' => $htftxx,
		'htftx2' => $htftx2,
		'htft21' => $htft21,
		'htft2x' => $htft2x,
		'htft22' => $htft22,
		'homebttsy' => $homeBTTSyes,
		'drawbttsy' => $drawBTTSyes,
		'awaybttsy' => $awayBTTSyes,
		'homebttsn' => $homeBTTSno,
		'drawbttsn' => $drawBTTSno,
		'awaybttsn' => $awayBTTSno,	
		'fgt0' => $fgt0,
		'fgt1' => $fgt1,
		'fgt2' => $fgt2,
		'fgt3' => $fgt3,
		'fgt4' => $fgt4,
		'fgt5' => $fgt5,
		'fgt6' => $fgt6,
		'pe00FT' => $pe00FT,
		'pe10FT' => $pe10FT,
		'pe20FT' => $pe20FT,
		'pe30FT' => $pe30FT,
		'pe40FT' => $pe40FT,
		'pe50FT' => $pe50FT,
		'pe60FT' => $pe60FT,
		'pe01FT' => $pe01FT,
		'pe11FT' => $pe11FT,
		'pe21FT' => $pe21FT,
		'pe31FT' => $pe31FT,
		'pe41FT' => $pe41FT,
		'pe51FT' => $pe51FT,
		'pe02FT' => $pe02FT,
		'pe12FT' => $pe12FT,
		'pe22FT' => $pe22FT,
		'pe32FT' => $pe32FT,
		'pe42FT' => $pe42FT,
		'pe03FT' => $pe03FT,
		'pe13FT' => $pe13FT,
		'pe23FT' => $pe23FT,
		'pe33FT' => $pe33FT,
		'pe04FT' => $pe04FT,
		'pe14FT' => $pe14FT,
		'pe24FT' => $pe24FT,
		'pe05FT' => $pe05FT,
		'pe15FT' => $pe15FT,
		'pe06FT' => $pe06FT,
		'pe00HT' => $pe00HT,
		'pe10HT' => $pe10HT,
		'pe20HT' => $pe20HT,
		'pe30HT' => $pe30HT,
		'pe01HT' => $pe01HT,
		'pe11HT' => $pe11HT,
		'pe21HT' => $pe21HT,
		'pe02HT' => $pe02HT,
		'pe12HT' => $pe12HT,
		'pe03HT' => $pe03HT,
		'book_id' => $book_id
	];
	
	
    $content = json_encode($data);
    $url = 'https://oaduikfnlwxirpeoqrjc.supabase.co/rest/v1/mcKironOdds'; 	
	$apiKey = 'eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJpc3MiOiJzdXBhYmFzZSIsInJlZiI6Im9hZHVpa2ZubHd4aXJwZW9xcmpjIiwicm9sZSI6ImFub24iLCJpYXQiOjE2OTQ0NzIzMjQsImV4cCI6MjAxMDA0ODMyNH0.YJFt69Ld-xZPqWLOuPCJp__hcRRpWL4D3SXclOQUWXU';            

	$curl = curl_init($url);
	curl_setopt($curl, CURLOPT_URL, $url);
	curl_setopt($curl, CURLOPT_POST, true);
	curl_setopt($curl, CURLOPT_RETURNTRANSFER, true); 
	$headers = array(
	   "apikey: ".$apiKey,
	   "Authorization: Bearer ".$apiKey,
	   "Content-Type: application/json",
	   "Prefer: return=minimal",
	);
	curl_setopt($curl, CURLOPT_HTTPHEADER, $headers);
	curl_setopt($curl, CURLOPT_POSTFIELDS, $content); 
	$resp = curl_exec($curl);
	$err = curl_error($curl);          

	curl_close($curl);            

	//file_get_contents('https://vsgroup1.com.br/dafabet/kiron/ai4.php?camp=mundo&bid='.$book_id.'&hg='.$placar_casaFT.'&ag='.$placar_foraFT);            

	if ($err) {
		echo "cURL Error #:" . $err;
	} else {
		file_get_contents('https://mwprosoccer.xyz/genOddsMCKironCache/'.$book_id);
		echo '<pre>';
		var_dump($resp);
		echo '</pre>';
	}
	
	
	
}

for($i = 0; $i < 5; $i++){
	
	$campId = $campIds[$i];
	$table = $tables[$i];
	
	$eventList = getEventList($campId);

	foreach($eventList AS $k => $jogo){
		
		$book_id = $jogo['id'];
		$name = explode(' vs. ', $jogo['name']);
		$homeTeam = $name[0];
		$awayTeam = $name[1];
		$game_id = $jogo['number'];
		
		$date = new DateTime($jogo['startDate']);   
		$date->sub(new DateInterval('PT3H'));
		$date = $date->format('Y-m-d\TH:i:s');	
		
		if($jogo['status'] == 0){ //Próximos
			if(!getPartida($book_id, $table)){
				$data = [
					"date"=>$date, 
					'book_id' => $book_id, 
					'game_id' => $game_id, 
					'casa' => $homeTeam, 
					'fora' => $awayTeam,
					'identifier' => $date.'_'				
				];
				saveData($data, $table);				
				$eventDetails = getEventDetails($book_id, $campId);
				saveOdds($eventDetails, $date);
			} else {
				echo 'Já Existe<br>';
			}	
		}		
	}

}